#include <iostream>
#include <vector>
using namespace std;

typedef long long ll;
typedef pair<int, int> pii;

int count_segments(const vector<int>& arr, int n) {
    int segments = 1;
    for (int i = 1; i < n; i++) {
        if (arr[i] < arr[i - 1]) {
            segments++;
        }
    }
    return segments;
}

int update_segments(vector<int>& arr, int n, int i, int j, int current_segments) {
    // ?????? ?? ?????????? ???? ???????? ???? ???? ?? ????? ?? ???? ?????????
    vector<int> affected = {i - 1, i, j - 1, j};
    
    // ????????? ???? ???????? ?? ???????
    for (int idx : affected) {
        if (idx >= 0 && idx < n - 1) {
            if (arr[idx] > arr[idx + 1]) current_segments--;
            if (arr[idx] <= arr[idx + 1]) current_segments++;
        }
    }

    // ???????? ??????
    swap(arr[i], arr[j]);

    // ?????? ??????? ???? ???? ????????
    for (int idx : affected) {
        if (idx >= 0 && idx < n - 1) {
            if (arr[idx] > arr[idx + 1]) current_segments++;
            if (arr[idx] <= arr[idx + 1]) current_segments--;
        }
    }

    return current_segments;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int N, Q;
    cin >> N >> Q;
    
    vector<int> P(N);
    for (int i = 0; i < N; i++) {
        cin >> P[i];
    }

    // ??????? ???? ?????????
    int segments = count_segments(P, N);
    cout << segments << '\n';

    for (int q = 0; q < Q; q++) {
        int i, j;
        cin >> i >> j;
        i--; j--;  // ?????????? ? 0-??????????? ???

        segments = update_segments(P, N, i, j, segments);
        cout << segments << '\n';
    }

    return 0;
}